//
//  TestGLESView.m
//  testapp
//
//  Created by Torsten Kammer on 19.04.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "TestGLESView.h"

#import <QuartzCore/QuartzCore.h>

@implementation TestGLESView

+ (Class)layerClass
{
	return [CAEAGLLayer class];
}

- (id)initWithCoder:(NSCoder *)coder
{
	[super initWithCoder:coder];
	
	context = [[EAGLContext alloc] initWithAPI:kEAGLRenderingAPIOpenGLES1];
	[EAGLContext setCurrentContext:context];
	
	
	glGenFramebuffersOES(1, &framebuffer);
	glGenRenderbuffersOES(1, &colorBuffer);
	glGenRenderbuffersOES(1, &depthBuffer);
	
	glBindFramebufferOES(GL_FRAMEBUFFER_OES, framebuffer);
	
	glBindRenderbufferOES(GL_RENDERBUFFER_OES, colorBuffer);
	[context renderbufferStorage:GL_RENDERBUFFER_OES fromDrawable:(CAEAGLLayer *) self.layer];
	glFramebufferRenderbufferOES(GL_FRAMEBUFFER_OES, GL_COLOR_ATTACHMENT0_OES, GL_RENDERBUFFER_OES, colorBuffer);
	
	GLint width, height;
	glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES, GL_RENDERBUFFER_WIDTH_OES, &width);
	glGetRenderbufferParameterivOES(GL_RENDERBUFFER_OES, GL_RENDERBUFFER_HEIGHT_OES, &height);
	
	glBindRenderbufferOES(GL_RENDERBUFFER_OES, depthBuffer);
	glRenderbufferStorageOES(GL_RENDERBUFFER_OES, GL_DEPTH_COMPONENT16_OES, width, height);
	glFramebufferRenderbufferOES(GL_FRAMEBUFFER_OES, GL_DEPTH_ATTACHMENT_OES, GL_RENDERBUFFER_OES, depthBuffer);
	
	
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	
	glViewport(0, 0, width, height);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrthof(0.0f, width, 0.0f, height, -1.0f, 1.0f);
	glMatrixMode(GL_MODELVIEW);
	
	
	[self performSelector:@selector(drawSomething) withObject:nil afterDelay:0.0];
	
	return self;
}

- (void)drawSomething;
{
	[EAGLContext setCurrentContext:context];
	
	glClear(GL_COLOR_BUFFER_BIT);
	
	float data[] = {
		40.0f, 40.0f,		0.5f, 1.0f, 0.0f, 1.0f,
		200.0f, 200.0f,	1.0f, 0.0f, 0.5f, 1.0f,
		600.0f, 40.0f,	0.0f, 0.5f, 1.0f, 1.0f
	};
	
	glVertexPointer(2, GL_FLOAT, sizeof(float [6]), data);
	glColorPointer(4, GL_FLOAT, sizeof(float [6]), &(data[2]));
	
	glDrawArrays(GL_TRIANGLES, 0, 3);

	glBindRenderbufferOES(GL_RENDERBUFFER_OES, colorBuffer);
	[context presentRenderbuffer:GL_RENDERBUFFER_OES];
}

- (void)dealloc
{
    [super dealloc];
}

@end
